/*
 * Decompiled with CFR 0.152.
 */
package com.github.dumann089.theatricalextralights.blockentities;

import com.github.dumann089.theatricalextralights.blockentities.BlockEntities;
import com.github.dumann089.theatricalextralights.blocks.Beam7RBlock;
import com.github.dumann089.theatricalextralights.fixtures.Fixtures;
import dev.imabad.theatrical.api.Fixture;
import dev.imabad.theatrical.blockentities.light.BaseDMXConsumerLightBlockEntity;
import java.util.Arrays;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public class Beam7RBlockEntity
extends BaseDMXConsumerLightBlockEntity {
    public Beam7RBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
        this.setChannelCount(7);
    }

    public Beam7RBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)BlockEntities.BEAM_7R.get(), pos, state);
    }

    public Fixture getFixture() {
        return (Fixture)Fixtures.BEAM_7R.get();
    }

    public void consume(byte[] dmxValues) {
        int start = this.getChannelStart() > 0 ? this.getChannelStart() - 1 : 0;
        byte[] ourValues = Arrays.copyOfRange(dmxValues, start, start + this.getChannelCount());
        if (ourValues.length < 7) {
            return;
        }
        if (this.storePrev()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
        this.intensity = this.convertByteToInt(ourValues[0]);
        this.red = this.convertByteToInt(ourValues[1]);
        this.green = this.convertByteToInt(ourValues[2]);
        this.blue = this.convertByteToInt(ourValues[3]);
        this.focus = this.convertByteToInt(ourValues[4]);
        this.pan = (int)((float)(this.convertByteToInt(ourValues[5]) * 360) / 255.0f) - 180;
        this.tilt = (int)((float)(this.convertByteToInt(ourValues[6]) * 270) / 255.0f) - 225;
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        this.method_5431();
    }

    public int getDeviceTypeId() {
        return 1;
    }

    public String getModelName() {
        return "Beam 7r";
    }

    public class_2960 getFixtureId() {
        return Fixtures.BEAM_7R.getId();
    }

    public int getActivePersonality() {
        return 0;
    }

    public int convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    public boolean isUpsideDown() {
        return (Boolean)this.method_11010().method_11654((class_2769)Beam7RBlock.HANGING) != false && this.method_11010().method_11654((class_2769)Beam7RBlock.HANG_DIRECTION) == class_2350.field_11036;
    }

    public int getBasePan() {
        return 0;
    }

    public String getTranslationKey() {
        return "block.theatricalextralights.beam_7r";
    }
}

