/*
 * Decompiled with CFR 0.152.
 */
package com.github.dumann089.theatricalextralights.blockentities;

import com.github.dumann089.theatricalextralights.blockentities.BlockEntities;
import com.github.dumann089.theatricalextralights.blocks.ParScrollerBlock;
import com.github.dumann089.theatricalextralights.fixtures.Fixtures;
import dev.imabad.theatrical.api.Fixture;
import dev.imabad.theatrical.blockentities.light.BaseDMXConsumerLightBlockEntity;
import java.util.Arrays;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class ParScrollerBlockEntity
extends BaseDMXConsumerLightBlockEntity {
    private static final float[][] GELS = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {1.0f, 0.5f, 0.0f}, {1.0f, 1.0f, 1.0f}};

    public ParScrollerBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntities.PARSCROLLER.get(), pos, state);
        this.setChannelCount(2);
    }

    public Fixture getFixture() {
        return (Fixture)Fixtures.PARSCROLLER.get();
    }

    public int getFocus() {
        return 255;
    }

    public void consume(byte[] dmxValues) {
        int start = this.getChannelStart() > 0 ? this.getChannelStart() - 1 : 0;
        byte[] ourValues = Arrays.copyOfRange(dmxValues, start, Math.min(start + this.getChannelCount(), dmxValues.length));
        if (ourValues.length < 2) {
            return;
        }
        if (this.storePrev()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
        this.intensity = this.convertByteToInt(ourValues[0]);
        int scrollerValue = this.convertByteToInt(ourValues[1]);
        float gelPosition = (float)scrollerValue / 255.0f * (float)(GELS.length - 1);
        int gel1Index = (int)Math.floor(gelPosition);
        int gel2Index = (int)Math.ceil(gelPosition);
        float blendFactor = gelPosition - (float)gel1Index;
        gel1Index = class_3532.method_15340((int)gel1Index, (int)0, (int)(GELS.length - 1));
        gel2Index = class_3532.method_15340((int)gel2Index, (int)0, (int)(GELS.length - 1));
        float[] gel1 = GELS[gel1Index];
        float[] gel2 = GELS[gel2Index];
        float r = class_3532.method_16439((float)blendFactor, (float)gel1[0], (float)gel2[0]);
        float g = class_3532.method_16439((float)blendFactor, (float)gel1[1], (float)gel2[1]);
        float b = class_3532.method_16439((float)blendFactor, (float)gel1[2], (float)gel2[2]);
        this.red = (int)(r * 255.0f);
        this.green = (int)(g * 255.0f);
        this.blue = (int)(b * 255.0f);
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        this.method_5431();
    }

    public int getDeviceTypeId() {
        return 2;
    }

    public String getModelName() {
        return "Par Scroller";
    }

    public boolean isUpsideDown() {
        return (Boolean)this.method_11010().method_11654((class_2769)ParScrollerBlock.HANGING) != false && this.method_11010().method_11654((class_2769)ParScrollerBlock.HANG_DIRECTION) == class_2350.field_11036;
    }

    public class_2960 getFixtureId() {
        return Fixtures.PARSCROLLER.getId();
    }

    public int getActivePersonality() {
        return 0;
    }

    public int convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    public String getTranslationKey() {
        return "block.theatricalextralights.parscroller";
    }
}

