/*
 * Decompiled with CFR 0.152.
 */
package com.github.dumann089.theatricalextralights.blockentities;

import com.github.dumann089.theatricalextralights.blockentities.BlockEntities;
import com.github.dumann089.theatricalextralights.blockentities.interfaces.HasJetHeight;
import com.github.dumann089.theatricalextralights.blockentities.interfaces.HasJetThickness;
import com.github.dumann089.theatricalextralights.client.particle.JetVariant;
import com.github.dumann089.theatricalextralights.client.particle.WaterJetParticleOptions;
import com.github.dumann089.theatricalextralights.fixtures.Fixtures;
import dev.imabad.theatrical.api.Fixture;
import dev.imabad.theatrical.blockentities.light.BaseDMXConsumerLightBlockEntity;
import java.util.Arrays;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class WaterJetBigBlockEntity
extends BaseDMXConsumerLightBlockEntity
implements HasJetHeight,
HasJetThickness {
    public double smoothedHeight = 0.0;
    private float jetHeight = 5.0f;
    private float jetThickness = 0.7f;
    private int tickCounter = 0;
    public static final float MIN_THICKNESS = 0.05f;
    public static final float MAX_THICKNESS = 55.5f;
    public static final float MIN_JET_HEIGHT = 0.1f;
    public static final float MAX_JET_HEIGHT = 99.0f;

    public WaterJetBigBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntities.WATER_JET_BIG.get(), pos, state);
        this.setChannelCount(1);
    }

    @Override
    public float getJetThickness() {
        return this.jetThickness;
    }

    @Override
    public void setJetThickness(float thickness) {
        this.jetThickness = class_3532.method_15363((float)thickness, (float)0.05f, (float)55.5f);
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    @Override
    public float getJetHeight() {
        return this.jetHeight;
    }

    @Override
    public void setJetHeight(float h) {
        this.jetHeight = class_3532.method_15363((float)h, (float)0.1f, (float)99.0f);
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public void consume(byte[] dmxValues) {
        int start = this.getChannelStart() > 0 ? this.getChannelStart() - 1 : 0;
        byte[] ourValues = Arrays.copyOfRange(dmxValues, start, start + this.getChannelCount());
        if (ourValues.length < 1) {
            return;
        }
        this.intensity = this.convertByteToInt(ourValues[0]);
        if (this.storePrev()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
        this.method_5431();
    }

    public int convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    public void tick() {
        if (!this.field_11863.field_9236 || class_310.method_1551().method_1493()) {
            return;
        }
        ++this.tickCounter;
        double x = (double)this.field_11867.method_10263() + 0.5;
        double y = this.field_11867.method_10264();
        double z = (double)this.field_11867.method_10260() + 0.5;
        double targetHeight = (double)this.intensity / 255.0 * (double)this.jetHeight;
        this.smoothedHeight += (targetHeight - this.smoothedHeight) * 0.1;
        if (this.tickCounter % 6 == 0) {
            float intensityNorm = (float)this.intensity / 255.0f;
            this.field_11863.method_17452((class_2394)new WaterJetParticleOptions(intensityNorm, this.jetThickness, JetVariant.JET1), true, x, y + this.smoothedHeight, z, 0.0, 0.0, 0.0);
        }
    }

    public Fixture getFixture() {
        return (Fixture)Fixtures.WATER_JET_BIG.get();
    }

    public int getFocus() {
        return 255;
    }

    public int getDeviceTypeId() {
        return 2;
    }

    public String getModelName() {
        return "Water Jet Big";
    }

    public class_2960 getFixtureId() {
        return Fixtures.WATER_JET_BIG.getId();
    }

    public int getActivePersonality() {
        return 0;
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10548("JetHeight", this.jetHeight);
        tag.method_10548("JetThickness", this.jetThickness);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("JetHeight")) {
            this.jetHeight = tag.method_10583("JetHeight");
        }
        if (tag.method_10545("JetThickness")) {
            this.jetThickness = tag.method_10583("JetThickness");
        }
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        tag.method_10548("JetHeight", this.jetHeight);
        tag.method_10548("JetThickness", this.jetThickness);
        return tag;
    }

    public String getTranslationKey() {
        return "block.theatricalextralights.water_jet_big";
    }
}

