/*
 * Decompiled with CFR 0.152.
 */
package com.github.dumann089.theatricalextralights.blockentities;

import com.github.dumann089.theatricalextralights.blockentities.BlockEntities;
import com.github.dumann089.theatricalextralights.fixtures.Fixtures;
import com.github.dumann089.theatricalextralights.particle.ModParticle;
import dev.imabad.theatrical.api.Fixture;
import dev.imabad.theatrical.blockentities.light.BaseDMXConsumerLightBlockEntity;
import java.util.Arrays;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class WaterJetBlockEntity
extends BaseDMXConsumerLightBlockEntity {
    public double smoothedHeight = 0.0;
    private int tickCounter = 0;

    public WaterJetBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntities.WATER_JET.get(), pos, state);
        this.setChannelCount(1);
    }

    public Fixture getFixture() {
        return (Fixture)Fixtures.WATER_JET.get();
    }

    public int getFocus() {
        return 255;
    }

    public void consume(byte[] dmxValues) {
        int start = this.getChannelStart() > 0 ? this.getChannelStart() - 1 : 0;
        byte[] ourValues = Arrays.copyOfRange(dmxValues, start, start + this.getChannelCount());
        if (ourValues.length < 1) {
            return;
        }
        if (this.storePrev()) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
        this.intensity = this.convertByteToInt(ourValues[0]);
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        this.method_5431();
    }

    public int getDeviceTypeId() {
        return 2;
    }

    public String getModelName() {
        return "Water Jet";
    }

    public class_2960 getFixtureId() {
        return Fixtures.WATER_JET.getId();
    }

    public int getActivePersonality() {
        return 0;
    }

    public int convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    public void tick() {
        if (!this.field_11863.field_9236 || class_310.method_1551().method_1493()) {
            return;
        }
        double x = (double)this.field_11867.method_10263() + 0.5;
        double y = this.field_11867.method_10264();
        double z = (double)this.field_11867.method_10260() + 0.5;
        double maxHeight = 3.0;
        double targetHeight = (double)this.intensity / 255.0 * maxHeight;
        double normalizedIntensity = (double)this.intensity / 255.0;
        this.smoothedHeight += (targetHeight - this.smoothedHeight) * 0.1;
        if (this.tickCounter % 8 == 0) {
            this.field_11863.method_17452((class_2394)ModParticle.WATERJETPARTICLE.get(), true, x, y + this.smoothedHeight, z, 0.0, (double)this.intensity / 255.0, 0.0);
        }
    }

    public String getTranslationKey() {
        return "block.theatricalextralights.water_jet";
    }
}

