/*
 * Decompiled with CFR 0.152.
 */
package com.github.dumann089.theatricalextralights.client.blockentities;

import com.github.dumann089.theatricalextralights.blockentities.LaserBlockEntity;
import com.github.dumann089.theatricalextralights.config.TheatricalExtraLightsConfig;
import dev.imabad.theatrical.TheatricalExpectPlatform;
import dev.imabad.theatrical.blocks.HangableBlock;
import dev.imabad.theatrical.client.LazyRenderers;
import dev.imabad.theatrical.client.TheatricalRenderTypes;
import dev.imabad.theatrical.client.blockentities.FixtureRenderer;
import java.util.Optional;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class LaserRenderer
extends FixtureRenderer<LaserBlockEntity> {
    private class_1087 cachedPanModel;
    private class_1087 cachedTiltModel;
    private class_1087 cachedStaticModel;

    public LaserRenderer(class_5614.class_5615 context) {
        super(context);
    }

    public void renderModel(LaserBlockEntity blockEntity, class_4587 poseStack, class_4588 vertexConsumer, class_2350 facing, float partialTicks, boolean isFlipped, class_2680 blockState, boolean isHanging, int packedLight, int packedOverlay) {
        if (this.cachedStaticModel == null) {
            this.cachedStaticModel = TheatricalExpectPlatform.getBakedModel((class_2960)blockEntity.getFixture().getStaticModel());
        }
        if (this.cachedPanModel == null) {
            this.cachedPanModel = TheatricalExpectPlatform.getBakedModel((class_2960)blockEntity.getFixture().getPanModel());
        }
        if (this.cachedTiltModel == null) {
            this.cachedTiltModel = TheatricalExpectPlatform.getBakedModel((class_2960)blockEntity.getFixture().getTiltModel());
        }
        poseStack.method_46416(0.5f, 0.0f, 0.5f);
        if (isHanging) {
            class_2350 hangDirection = (class_2350)blockState.method_11654((class_2769)HangableBlock.HANG_DIRECTION);
            poseStack.method_22904(0.0, 0.5, 0.0);
            if (hangDirection.method_10166() != class_2350.class_2351.field_11052) {
                if (hangDirection.method_10166() == class_2350.class_2351.field_11051) {
                    if (hangDirection == class_2350.field_11035) {
                        poseStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
                        poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                    } else {
                        poseStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
                        poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                    }
                } else if (hangDirection == class_2350.field_11034) {
                    poseStack.method_22907(class_7833.field_40717.rotationDegrees(-90.0f));
                } else {
                    poseStack.method_22907(class_7833.field_40717.rotationDegrees(90.0f));
                }
            }
            poseStack.method_22904(0.0, -0.5, 0.0);
        }
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(facing.method_10144()));
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        if (isHanging) {
            Optional optionalSupport = blockEntity.getSupportingStructure();
            if (optionalSupport.isPresent()) {
                float[] transforms = blockEntity.getFixture().getTransforms(blockState, (class_2680)optionalSupport.get());
                poseStack.method_46416(transforms[0], transforms[1], transforms[2]);
            } else {
                poseStack.method_22904(0.0, 0.19, 0.0);
            }
            poseStack.method_22904(0.0, -0.08, 0.0);
        }
        if (isFlipped) {
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            poseStack.method_22904(-0.5, -0.5, -0.5);
        }
        this.minecraftRenderModel(poseStack, vertexConsumer, blockState, this.cachedStaticModel, packedLight, packedOverlay);
        float[] pans = blockEntity.getFixture().getPanRotationPosition();
        poseStack.method_46416(pans[0], pans[1], pans[2]);
        int prevPan = blockEntity.getPrevPan();
        int pan = blockEntity.getPan();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)prevPan + (float)(pan - prevPan) * partialTicks));
        poseStack.method_46416(-pans[0], -pans[1], -pans[2]);
        this.minecraftRenderModel(poseStack, vertexConsumer, blockState, this.cachedPanModel, packedLight, packedOverlay);
        float[] tilts = blockEntity.getFixture().getTiltRotationPosition();
        poseStack.method_46416(tilts[0], tilts[1], tilts[2]);
        int prevTilt = blockEntity.getPrevTilt();
        int tilt = blockEntity.getTilt();
        if (isFlipped) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(-180.0f));
        } else {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        }
        poseStack.method_22907(class_7833.field_40714.rotationDegrees((float)prevTilt + (float)(tilt - prevTilt) * partialTicks));
        poseStack.method_46416(-tilts[0], -tilts[1], -tilts[2]);
        this.minecraftRenderModel(poseStack, vertexConsumer, blockState, this.cachedTiltModel, packedLight, packedOverlay);
    }

    public void beforeRenderBeam(final LaserBlockEntity blockEntity, class_4587 poseStack, class_4588 vertexConsumer, class_4597 multiBufferSource, final class_2350 facing, float partialTicks, final boolean isFlipped, final class_2680 blockstate, final boolean isHanging, int packedLight, int packedOverlay) {
        if (blockEntity.getIntensity() > 0.0f) {
            LazyRenderers.addLazyRender((LazyRenderers.LazyRenderer)new LazyRenderers.LazyRenderer(){

                public void render(class_4597.class_4598 bufferSource, class_4587 poseStack, class_4184 camera, float partialTick) {
                    poseStack.method_22903();
                    class_243 offset = class_243.method_24954((class_2382)blockEntity.method_11016()).method_1020(camera.method_19326());
                    poseStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
                    LaserRenderer.this.preparePoseStack(blockEntity, poseStack, facing, partialTick, isFlipped, blockstate, isHanging);
                    class_4588 beamConsumer = bufferSource.getBuffer(TheatricalRenderTypes.BEAM);
                    float intensity = (float)blockEntity.getPrevIntensity() + (blockEntity.getIntensity() - (float)blockEntity.getPrevIntensity()) * partialTick;
                    int color = blockEntity.getColour();
                    int r = color >> 16 & 0xFF;
                    int g = color >> 8 & 0xFF;
                    int b = color & 0xFF;
                    int a = (int)(intensity / 255.0f * 255.0f);
                    class_243 baseOrigin = new class_243(0.5, 0.5, 0.0);
                    if (isHanging) {
                        baseOrigin = new class_243(baseOrigin.field_1352, 1.0 - baseOrigin.field_1351, baseOrigin.field_1350);
                    }
                    int focus = blockEntity.getFocus();
                    int beamCount = Math.max(1, Math.min(9, (int)Math.ceil((float)focus / 255.0f * 9.0f)));
                    float[] angles = this.generateAngles(beamCount);
                    float beamLength = TheatricalExtraLightsConfig.getLaserBeamLength();
                    float beamWidth = 0.03f;
                    for (float angle : angles) {
                        poseStack.method_22903();
                        poseStack.method_22904(baseOrigin.field_1352, baseOrigin.field_1351, baseOrigin.field_1350);
                        double angleRad = Math.toRadians(angle);
                        poseStack.method_22907(class_7833.field_40716.rotation((float)angleRad));
                        Matrix4f m = poseStack.method_23760().method_23761();
                        Matrix3f normal = poseStack.method_23760().method_23762();
                        float alpha = intensity / 255.0f;
                        LaserRenderer.this.renderLightBeam(beamConsumer, poseStack, blockEntity, partialTick, alpha, beamWidth, beamLength, color);
                        poseStack.method_22909();
                    }
                    poseStack.method_22909();
                }

                public class_243 getPos(float partialTick) {
                    return blockEntity.method_11016().method_46558();
                }

                private float[] generateAngles(int count) {
                    if (count == 1) {
                        return new float[]{0.0f};
                    }
                    float[] angles = new float[count];
                    float maxAngle = 15.0f;
                    float step = 2.0f * maxAngle / (float)(count - 1);
                    for (int i = 0; i < count; ++i) {
                        angles[i] = -maxAngle + (float)i * step;
                    }
                    return angles;
                }
            });
        }
    }

    protected void renderLightBeam(class_4588 builder, class_4587 stack, LaserBlockEntity tileEntityFixture, float partialTicks, float alpha, float beamSize, float length, int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = (int)(alpha * 255.0f);
        Matrix4f m = stack.method_23760().method_23761();
        Matrix3f normal = stack.method_23760().method_23762();
        float focus = 1.0f;
        float endMultiplier = beamSize * focus;
        this.addVertex(builder, m, normal, r, g, b, 0, beamSize * endMultiplier, beamSize * endMultiplier, length);
        this.addVertex(builder, m, normal, r, g, b, a, beamSize, beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, a, beamSize, -beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, 0, beamSize * endMultiplier, -beamSize * endMultiplier, length);
        this.addVertex(builder, m, normal, r, g, b, 0, -beamSize * endMultiplier, -beamSize * endMultiplier, length);
        this.addVertex(builder, m, normal, r, g, b, a, -beamSize, -beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, a, -beamSize, beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, 0, -beamSize * endMultiplier, beamSize * endMultiplier, length);
        this.addVertex(builder, m, normal, r, g, b, 0, -beamSize * endMultiplier, beamSize * endMultiplier, length);
        this.addVertex(builder, m, normal, r, g, b, a, -beamSize, beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, a, beamSize, beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, 0, beamSize * endMultiplier, beamSize * endMultiplier, length);
        this.addVertex(builder, m, normal, r, g, b, 0, beamSize * endMultiplier, -beamSize * endMultiplier, length);
        this.addVertex(builder, m, normal, r, g, b, a, beamSize, -beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, a, -beamSize, -beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, 0, -beamSize * endMultiplier, -beamSize * endMultiplier, length);
    }

    public void preparePoseStack(LaserBlockEntity blockEntity, class_4587 poseStack, class_2350 facing, float partialTicks, boolean isFlipped, class_2680 blockState, boolean isHanging) {
        poseStack.method_46416(0.5f, 0.0f, 0.5f);
        if (isHanging) {
            class_2350 hangDirection = (class_2350)blockState.method_11654((class_2769)HangableBlock.HANG_DIRECTION);
            poseStack.method_22904(0.0, 0.5, 0.0);
            if (hangDirection.method_10166() != class_2350.class_2351.field_11052) {
                if (hangDirection.method_10166() == class_2350.class_2351.field_11051) {
                    if (hangDirection == class_2350.field_11035) {
                        poseStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
                        poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                    } else {
                        poseStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
                        poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                    }
                } else if (hangDirection == class_2350.field_11034) {
                    poseStack.method_22907(class_7833.field_40717.rotationDegrees(-90.0f));
                } else {
                    poseStack.method_22907(class_7833.field_40717.rotationDegrees(90.0f));
                }
            }
            poseStack.method_22904(0.0, -0.5, 0.0);
        }
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(facing.method_10144()));
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        if (isHanging) {
            Optional optionalSupport = blockEntity.getSupportingStructure();
            if (optionalSupport.isPresent()) {
                float[] transforms = blockEntity.getFixture().getTransforms(blockState, (class_2680)optionalSupport.get());
                poseStack.method_46416(transforms[0], transforms[1], transforms[2]);
            } else {
                poseStack.method_22904(0.0, 0.19, 0.0);
            }
            poseStack.method_22904(0.0, -0.08, 0.0);
        }
        if (isFlipped) {
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            poseStack.method_22904(-0.5, -0.5, -0.5);
        }
        float[] pans = blockEntity.getFixture().getPanRotationPosition();
        poseStack.method_46416(pans[0], pans[1], pans[2]);
        int prevPan = blockEntity.getPrevPan();
        int pan = blockEntity.getPan();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)prevPan + (float)(pan - prevPan) * partialTicks));
        poseStack.method_46416(-pans[0], -pans[1], -pans[2]);
        float[] tilts = blockEntity.getFixture().getTiltRotationPosition();
        poseStack.method_46416(tilts[0], tilts[1], tilts[2]);
        int prevTilt = blockEntity.getPrevTilt();
        int tilt = blockEntity.getTilt();
        if (isFlipped) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(-180.0f));
        } else {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        }
        poseStack.method_22907(class_7833.field_40714.rotationDegrees((float)prevTilt + (float)(tilt - prevTilt) * partialTicks));
        poseStack.method_46416(-tilts[0], -tilts[1], -tilts[2]);
    }
}

