/*
 * Decompiled with CFR 0.152.
 */
package com.github.dumann089.theatricalextralights.client.blockentities;

import com.github.dumann089.theatricalextralights.blockentities.SpinnerBlockEntity;
import com.github.dumann089.theatricalextralights.client.particle.JetVariant;
import com.github.dumann089.theatricalextralights.client.particle.WaterJetParticleOptions;
import dev.imabad.theatrical.TheatricalExpectPlatform;
import dev.imabad.theatrical.blocks.HangableBlock;
import dev.imabad.theatrical.client.LazyRenderers;
import dev.imabad.theatrical.client.blockentities.FixtureRenderer;
import java.util.Optional;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;

public class SpinnerRenderer
extends FixtureRenderer<SpinnerBlockEntity> {
    private class_1087 cachedPanModel;
    private class_1087 cachedTiltModel;
    private class_1087 cachedStaticModel;

    public SpinnerRenderer(class_5614.class_5615 context) {
        super(context);
    }

    public void renderModel(SpinnerBlockEntity blockEntity, class_4587 poseStack, class_4588 vertexConsumer, class_2350 facing, float partialTicks, boolean isFlipped, class_2680 blockState, boolean isHanging, int packedLight, int packedOverlay) {
        if (this.cachedStaticModel == null) {
            this.cachedStaticModel = TheatricalExpectPlatform.getBakedModel((class_2960)blockEntity.getFixture().getStaticModel());
        }
        if (this.cachedPanModel == null) {
            this.cachedPanModel = TheatricalExpectPlatform.getBakedModel((class_2960)blockEntity.getFixture().getPanModel());
        }
        if (this.cachedTiltModel == null) {
            this.cachedTiltModel = TheatricalExpectPlatform.getBakedModel((class_2960)blockEntity.getFixture().getTiltModel());
        }
        poseStack.method_46416(0.5f, 0.0f, 0.5f);
        if (isHanging) {
            class_2350 hangDirection = (class_2350)blockState.method_11654((class_2769)HangableBlock.HANG_DIRECTION);
            poseStack.method_22904(0.0, 0.5, 0.0);
            if (hangDirection.method_10166() != class_2350.class_2351.field_11052) {
                if (hangDirection.method_10166() == class_2350.class_2351.field_11051) {
                    if (hangDirection == class_2350.field_11035) {
                        poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                    } else {
                        poseStack.method_22907(class_7833.field_40713.rotationDegrees(90.0f));
                    }
                } else if (hangDirection == class_2350.field_11034) {
                    poseStack.method_22907(class_7833.field_40717.rotationDegrees(90.0f));
                } else {
                    poseStack.method_22907(class_7833.field_40717.rotationDegrees(-90.0f));
                }
            }
            poseStack.method_22904(0.0, -0.5, 0.0);
        }
        if (facing.method_10166() == class_2350.class_2351.field_11048) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(facing.method_10144()));
        } else {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(facing.method_10153().method_10144()));
        }
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        if (isHanging) {
            Optional optionalSupport = blockEntity.getSupportingStructure();
            if (optionalSupport.isPresent()) {
                float[] transforms = blockEntity.getFixture().getTransforms(blockState, (class_2680)optionalSupport.get());
                poseStack.method_46416(transforms[0], transforms[1], transforms[2]);
            } else {
                poseStack.method_22904(0.0, 0.19, 0.0);
            }
        }
        this.minecraftRenderModel(poseStack, vertexConsumer, blockState, this.cachedStaticModel, packedLight, packedOverlay);
        float[] pans = blockEntity.getFixture().getPanRotationPosition();
        poseStack.method_46416(pans[0], pans[1], pans[2]);
        float prevAngle = blockEntity.getPrevSpinAngle();
        float currentAngle = blockEntity.getSpinAngle();
        float interpolatedAngle = prevAngle + (currentAngle - prevAngle) * partialTicks;
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(interpolatedAngle));
        poseStack.method_46416(-pans[0], -pans[1], -pans[2]);
        this.minecraftRenderModel(poseStack, vertexConsumer, blockState, this.cachedPanModel, packedLight, packedOverlay);
        float[] tilts = blockEntity.getFixture().getTiltRotationPosition();
        poseStack.method_46416(tilts[0], tilts[1], tilts[2]);
        int prevTilt = blockEntity.getPrevTilt();
        int tilt = blockEntity.getTilt();
        poseStack.method_22907(class_7833.field_40714.rotationDegrees((float)prevTilt + (float)(tilt - prevTilt) * partialTicks));
        poseStack.method_46416(-tilts[0], -tilts[1], -tilts[2]);
        this.minecraftRenderModel(poseStack, vertexConsumer, blockState, this.cachedTiltModel, packedLight, packedOverlay);
    }

    public void beforeRenderBeam(final SpinnerBlockEntity blockEntity, class_4587 poseStack, class_4588 vertexConsumer, class_4597 multiBufferSource, class_2350 facing, float partialTicks, boolean isFlipped, class_2680 blockstate, boolean isHanging, int packedLight, int packedOverlay) {
        if (blockEntity.getIntensity() <= 0.0f) {
            return;
        }
        SpinnerBlockEntity.tick(blockEntity);
        LazyRenderers.addLazyRender((LazyRenderers.LazyRenderer)new LazyRenderers.LazyRenderer(){

            public void render(class_4597.class_4598 bufferSource, class_4587 poseStack, class_4184 camera, float partialTick) {
                if (class_310.method_1551().method_1493()) {
                    return;
                }
                class_243 camOffset = class_243.method_24954((class_2382)blockEntity.method_11016()).method_1020(camera.method_19326());
                poseStack.method_22903();
                poseStack.method_22904(camOffset.field_1352, camOffset.field_1351, camOffset.field_1350);
                float intensity = blockEntity.getIntensity() / 255.0f;
                float thickness = blockEntity.getJetThickness();
                double maxHeight = blockEntity.getJetHeight();
                double targetHeight = (double)intensity * maxHeight;
                blockEntity.smoothedHeight += (targetHeight - blockEntity.smoothedHeight) * 0.15;
                double speed = blockEntity.smoothedHeight * 0.1;
                float angle = blockEntity.getSpinAngle() % 360.0f;
                double rad = Math.toRadians(angle);
                float nozzleAngle = blockEntity.getNozzleAngle();
                double nozzleRad = Math.toRadians(nozzleAngle);
                double baseX = blockEntity.method_11016().method_10263();
                double baseY = blockEntity.method_11016().method_10264();
                double baseZ = blockEntity.method_11016().method_10260();
                double[][] jetPositions = new double[][]{{0.96, 2.0, 0.501}, {0.5, 2.0, 0.968}, {0.5, 2.0, 0.034}, {0.034, 2.0, 0.501}};
                if (blockEntity.method_10997() != null) {
                    WaterJetParticleOptions options = new WaterJetParticleOptions(intensity, thickness, JetVariant.JET3);
                    for (double[] jet : jetPositions) {
                        double localX = jet[0];
                        double localY = jet[1];
                        double localZ = jet[2];
                        double offsetX = localX - 0.5;
                        double offsetZ = localZ - 0.5;
                        double rotatedX = offsetX * Math.cos(rad) - offsetZ * Math.sin(rad);
                        double rotatedZ = offsetX * Math.sin(rad) + offsetZ * Math.cos(rad);
                        double worldX = baseX + 0.5 + rotatedX;
                        double worldY = baseY + localY;
                        double worldZ = baseZ + 0.5 + rotatedZ;
                        double dirX = rotatedX;
                        double dirZ = rotatedZ;
                        double dirLength = Math.sqrt(dirX * dirX + dirZ * dirZ);
                        if (dirLength > 0.001) {
                            dirX /= dirLength;
                            dirZ /= dirLength;
                        } else {
                            dirX = 0.0;
                            dirZ = 0.0;
                        }
                        double velY = speed * Math.cos(nozzleRad);
                        double horizontalSpeed = speed * Math.sin(nozzleRad);
                        double velX = dirX * horizontalSpeed;
                        double velZ = dirZ * horizontalSpeed;
                        blockEntity.method_10997().method_17452((class_2394)options, true, worldX, worldY, worldZ, velX, velY, velZ);
                    }
                }
                poseStack.method_22909();
            }

            public class_243 getPos(float partialTick) {
                return blockEntity.method_11016().method_46558();
            }
        });
    }

    public void preparePoseStack(SpinnerBlockEntity blockEntity, class_4587 poseStack, class_2350 facing, float partialTicks, boolean isFlipped, class_2680 blockState, boolean isHanging) {
        poseStack.method_46416(0.5f, 0.0f, 0.5f);
        if (isHanging) {
            class_2350 hangDirection = (class_2350)blockState.method_11654((class_2769)HangableBlock.HANG_DIRECTION);
            poseStack.method_22904(0.0, 0.5, 0.0);
            if (hangDirection.method_10166() != class_2350.class_2351.field_11052) {
                if (hangDirection.method_10166() == class_2350.class_2351.field_11051) {
                    if (hangDirection == class_2350.field_11035) {
                        poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                    } else {
                        poseStack.method_22907(class_7833.field_40713.rotationDegrees(90.0f));
                    }
                } else if (hangDirection == class_2350.field_11034) {
                    poseStack.method_22907(class_7833.field_40717.rotationDegrees(90.0f));
                } else {
                    poseStack.method_22907(class_7833.field_40717.rotationDegrees(-90.0f));
                }
            }
            poseStack.method_22904(0.0, -0.5, 0.0);
        }
        if (facing.method_10166() == class_2350.class_2351.field_11048) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(facing.method_10144()));
        } else {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(facing.method_10153().method_10144()));
        }
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        if (isHanging) {
            Optional optionalSupport = blockEntity.getSupportingStructure();
            if (optionalSupport.isPresent()) {
                float[] transforms = blockEntity.getFixture().getTransforms(blockState, (class_2680)optionalSupport.get());
                poseStack.method_46416(transforms[0], transforms[1], transforms[2]);
            } else {
                poseStack.method_22904(0.0, 0.19, 0.0);
            }
        }
        float[] pans = blockEntity.getFixture().getPanRotationPosition();
        poseStack.method_46416(pans[0], pans[1], pans[2]);
        float prevAngle = blockEntity.getPrevSpinAngle();
        float currentAngle = blockEntity.getSpinAngle();
        float interpolatedAngle = prevAngle + (currentAngle - prevAngle) * partialTicks;
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(interpolatedAngle));
        poseStack.method_46416(-pans[0], -pans[1], -pans[2]);
        float[] tilts = blockEntity.getFixture().getTiltRotationPosition();
        poseStack.method_46416(tilts[0], tilts[1], tilts[2]);
        int prevTilt = blockEntity.getPrevTilt();
        int tilt = blockEntity.getTilt();
        poseStack.method_22907(class_7833.field_40714.rotationDegrees((float)prevTilt + (float)(tilt - prevTilt) * partialTicks));
        poseStack.method_46416(-tilts[0], -tilts[1], -tilts[2]);
    }
}

