/*
 * Decompiled with CFR 0.152.
 */
package com.github.dumann089.theatricalextralights.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class TheatricalExtraLightsConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File FILE = new File("config/theatricalextralights.json");
    private float laserBeamLength = 60.0f;
    private static TheatricalExtraLightsConfig INSTANCE = new TheatricalExtraLightsConfig();

    public static void load() {
        if (FILE.exists()) {
            try (FileReader reader = new FileReader(FILE);){
                INSTANCE = (TheatricalExtraLightsConfig)GSON.fromJson((Reader)reader, TheatricalExtraLightsConfig.class);
                if (TheatricalExtraLightsConfig.INSTANCE.laserBeamLength < 20.0f) {
                    TheatricalExtraLightsConfig.INSTANCE.laserBeamLength = 20.0f;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            TheatricalExtraLightsConfig.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(FILE);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void ensureValidValues() {
        if (this.laserBeamLength < 20.0f) {
            this.laserBeamLength = 20.0f;
        }
    }

    public static float getLaserBeamLength() {
        return TheatricalExtraLightsConfig.INSTANCE.laserBeamLength;
    }

    public static void setLaserBeamLength(float value) {
        TheatricalExtraLightsConfig.INSTANCE.laserBeamLength = Math.max(20.0f, value);
    }
}

