/*
 * Decompiled with CFR 0.152.
 */
package net.derfruhling.minecraft.create.trainperspective;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.derfruhling.minecraft.create.trainperspective.DebugMode;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final WatchService WATCH_SERVICE;
    private static final Path PATH;
    public static ModConfig INSTANCE;
    public boolean enabled = true;
    public boolean leanEnabled = true;
    public float leanMagnitude = 1.0f;
    public boolean rollEnabled = true;
    public float rollMagnitude = 1.0f;
    public boolean applyToOthers = true;
    public boolean applyToNonPlayerEntities = true;
    public List<class_2960> blockedEntities = new ArrayList<class_2960>();
    public DebugMode debugMode = DebugMode.NONE;

    private ModConfig() {
    }

    public static void tick() {
        WatchKey key = WATCH_SERVICE.poll();
        if (key != null) {
            for (WatchEvent<?> event : key.pollEvents()) {
                if (!event.context().toString().equals(PATH.getFileName().toString())) continue;
                INSTANCE = ModConfig.loadConfig();
                key.reset();
            }
        }
    }

    private static ModConfig loadConfig() {
        if (Files.exists(PATH, new LinkOption[0])) {
            try {
                String configJson = Files.readString(PATH);
                return (ModConfig)GSON.fromJson(configJson, ModConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ModConfig value = new ModConfig();
        value.save();
        return value;
    }

    public static class_437 createConfigScreen(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43471((String)"title.create_train_perspective.config")).setSavingRunnable(INSTANCE::save);
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.create_train_perspective.general"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.create_train_perspective.enabled"), ModConfig.INSTANCE.enabled).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.create_train_perspective.enabled.tooltip")}).setSaveConsumer(value -> {
            ModConfig.INSTANCE.enabled = value;
        }).setDefaultValue(true).build());
        SubCategoryBuilder leaning = entryBuilder.startSubCategory((class_2561)class_2561.method_43471((String)"category.create_train_perspective.leaning"));
        leaning.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.create_train_perspective.leaning.enabled"), ModConfig.INSTANCE.leanEnabled).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.create_train_perspective.leaning.enabled.tooltip")}).setSaveConsumer(value -> {
            ModConfig.INSTANCE.leanEnabled = value;
        }).setDefaultValue(true).build());
        leaning.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.create_train_perspective.leaning.roll_enabled"), ModConfig.INSTANCE.rollEnabled).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.create_train_perspective.leaning.roll_enabled.tooltip")}).setSaveConsumer(value -> {
            ModConfig.INSTANCE.rollEnabled = value;
        }).setDefaultValue(true).build());
        general.addEntry((AbstractConfigListEntry)leaning.build());
        SubCategoryBuilder multiplayer = entryBuilder.startSubCategory((class_2561)class_2561.method_43471((String)"category.create_train_perspective.multiplayer"));
        multiplayer.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.create_train_perspective.multiplayer.apply_to_others"), ModConfig.INSTANCE.applyToOthers).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.create_train_perspective.multiplayer.apply_to_others.tooltip")}).setSaveConsumer(value -> {
            ModConfig.INSTANCE.applyToOthers = value;
        }).setDefaultValue(true).build());
        general.addEntry((AbstractConfigListEntry)multiplayer.build());
        SubCategoryBuilder advanced = entryBuilder.startSubCategory((class_2561)class_2561.method_43471((String)"category.create_train_perspective.advanced"));
        advanced.add((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)class_2561.method_43471((String)"option.create_train_perspective.advanced.lean_magnitude"), ModConfig.INSTANCE.leanMagnitude).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.create_train_perspective.advanced.lean_magnitude.tooltip")}).setSaveConsumer(value -> {
            ModConfig.INSTANCE.leanMagnitude = value.floatValue();
        }).setDefaultValue(1.0f).build());
        advanced.add((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)class_2561.method_43471((String)"option.create_train_perspective.advanced.roll_magnitude"), ModConfig.INSTANCE.rollMagnitude).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.create_train_perspective.advanced.roll_magnitude.tooltip")}).setSaveConsumer(value -> {
            ModConfig.INSTANCE.rollMagnitude = value.floatValue();
        }).setDefaultValue(1.0f).build());
        advanced.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.create_train_perspective.advanced.apply_to_entities"), ModConfig.INSTANCE.applyToNonPlayerEntities).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.create_train_perspective.advanced.apply_to_entities.tooltip")}).setSaveConsumer(value -> {
            ModConfig.INSTANCE.applyToNonPlayerEntities = value;
        }).setDefaultValue(true).build());
        advanced.add((AbstractConfigListEntry)entryBuilder.startStrList((class_2561)class_2561.method_43471((String)"option.create_train_perspective.advanced.blocked_entities"), ModConfig.INSTANCE.blockedEntities.stream().map(class_2960::toString).toList()).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.create_train_perspective.advanced.blocked_entities.tooltip")}).setSaveConsumer(value -> {
            ModConfig.INSTANCE.blockedEntities = value.stream().map(class_2960::new).toList();
        }).setDefaultValue(new ArrayList()).build());
        SubCategoryBuilder debug = entryBuilder.startSubCategory((class_2561)class_2561.method_43471((String)"category.create_train_perspective.debug"));
        debug.add((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"category.create_train_perspective.debug.description").method_27692(class_124.field_1067)).build());
        debug.add((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)class_2561.method_43471((String)"option.create_train_perspective.debug.debug_mode"), DebugMode.class, (Enum)ModConfig.INSTANCE.debugMode).setSaveConsumer(value -> {
            ModConfig.INSTANCE.debugMode = value;
        }).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.create_train_perspective.debug.debug_mode")}).setEnumNameProvider(m -> class_2561.method_43471((String)("option.create_train_perspective.debug.debug_mode." + m.name().toLowerCase(Locale.US)))).setDefaultValue((Enum)DebugMode.NONE).build());
        advanced.add((AbstractConfigListEntry)debug.build());
        general.addEntry((AbstractConfigListEntry)advanced.build());
        return builder.build();
    }

    private void save() {
        try (BufferedWriter file = Files.newBufferedWriter(PATH, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        PATH = class_310.method_1551().field_1697.toPath().resolve("config").resolve("create-train-perspective.json");
        INSTANCE = ModConfig.loadConfig();
        try {
            WATCH_SERVICE = FileSystems.getDefault().newWatchService();
            PATH.getParent().register(WATCH_SERVICE, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

